package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.db.EventDAO;

public class EventDAOMock implements EventDAO {

	private HashMap<Integer,Event> IDHash = new HashMap<Integer,Event>();
	private boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(final Event event) {
		if (event == null) {
			throw new IllegalArgumentException();
		}
	
		initializeEventHash();
		
		if (event.getId() == 0) {
			event.setId(idCounter++);
		}
		
		// Hibernate does this automatically
		if (event.getRequest() != null && event.getRequest().getEvents() != null && event.getRequest().getEvents().contains(event) == false) {
			event.getRequest().getEvents().add(event);
		}
		
		IDHash.put(event.getId(), event);
	}
	
	@Override
	public void delete(final Event event) {
		if (event == null) {
			throw new IllegalArgumentException();
		}

		initializeEventHash();

		//TODO: delete the EventGroup entries, if any?  EventGroup does not appear to be used in the Mock framework.
		
		IDHash.remove(event.getId());	//remove the event from the hash
	}
	
	
	@Override
	public List<Event> listByActivityId(int activityId) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getActivity().getId() == activityId) {
				result.add(event);
			}
		}

		return result;	
	}

	

	@Override
	public List<Event> listByEventTypeAndRequestId(int eventTypeId,
			int requestId) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getEventType().getId() == eventTypeId 
				&& event.getRequest().getId() == requestId) {
				result.add(event);
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByActivityIdAndGroupId(int activityId, int groupId) {
		initializeEventHash();
		
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getActivity().getId() == activityId
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByRequestIdAndGroupId(int requestId, int groupId) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getId() == requestId
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByActivityIdAndGroupOrder(int activityId,
			int groupId, boolean isInitial) {
		initializeEventHash();
		
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getActivity().getId() == activityId
					&& event.isInitial() == isInitial
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByRequestIdAndGroupOrder(int requestId, int groupId,
			boolean isInitial) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getId() == requestId
					&& event.isInitial() == isInitial
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByEventTypeAndActivityIdAndGroupId(int eventTypeId,
			int activityId, int groupId) {
		initializeEventHash();
		
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getActivity().getId() == activityId
					&& event.getEventType().getId() == eventTypeId
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	

	@Override
	public List<Event> listByEventTypeAndActivityIdAndGroupOrder(
			int eventTypeId, int activityId, int groupId, boolean isInitial) {
		initializeEventHash();
		
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getActivity().getId() == activityId
					&& event.getEventType().getId() == eventTypeId
					&& event.isInitial() == isInitial
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByEventTypeAndRequestIdAndGroupOrder(
			int eventTypeId, int requestId, int groupId, boolean isInitial) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getId() == requestId
					&& event.getEventType().getId() == eventTypeId
					&& event.isInitial() == isInitial
					&& event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	@Override
	public List<Event> listByGroup(int groupId) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getGroups() != null) {
				
				for (Group group : event.getGroups()) {
					if (group.getId() == groupId) {
						result.add(event);
					}
				}
			}
		}

		return result;	
	}

	public List<Event> listByRequestId(int requestId) {
		List<Event> result = new ArrayList<Event>();
		
		initializeEventHash();
		
		for (Integer id: IDHash.keySet()) {
			Event event = IDHash.get(id);
			if (event.getRequest().getId() == requestId) {
				result.add(event);
			}
		}

		return result;	
	}

	
	@Override
	public List<EventSummary> listSummaryByRequestId(int requestId) {
		initializeEventHash();
		
		return new RequestEventSummaryDAOMock(requestId).build();
	}

	@Override
	public List<EventSummary> listSummaryByActivityId(int activityId) {
		initializeEventHash();
		
		return new ActivityEventSummaryDAOMock(activityId).build();
	}

	private void initializeEventHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

    @Override
    public List<Event> listByRequestIdAndGroupIdAndReviewId(int requestId, int groupId, int reviewId) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void deleteByEventAndRequest(int eventTypeId, int requestId) {
        // TODO Auto-generated method stub
        
    }

}
